import os

if __package__:
    from ... import lt
else:
    import sys
    sys.path.append("../..")
    import lt


def main():
    client = lt.Client()

    # Find first active input video source
    sourceURL = ""
    sources = {
        "lt100:/0/cvbs-in/0",
        "lt100:/0/svideo-in/0",
        "lt100:/0/dvi-in/0", "lt100:/0/dvi-in/1",
        "lt100:/0/sdi-in/0", "lt100:/0/sdi-in/1",
    }
    for source in sources:
        input, err = client.Get(source)
        if err != None:
            exit(err)
        if input['video']['signal'] == 'locked':
            sourceURL = source
            break

    # If no active input video source found, use a default one
    if sourceURL == "":
        print("no active input video source found")
        sourceURL = "lt100:/0/sdi-in/0"

    # Create worker
    resp, err = client.Post(sourceURL+"/file", {'media': "video/mp4", 'location': os.getcwd()})
    if not lt.ErrorIs(err, lt.ErrRedirect):
        exit(err)
    workerURL = lt.RedirectLocation(err)

    # Loop
    while True:
        try:
            # Fetch worker update
            worker, err = client.Get(workerURL)
            if err != None:
                exit(err)

            # Packet data
            if len(worker['packets']) == 0:
                exit("packet not found")
            packet = worker['packets'][0]

            # Packet metadata
            meta = packet['meta']

            print('\r{:s} {:s} {:d}x{:d} {:d} bytes'.format(sourceURL, worker['name'], meta['size'][0], meta['size'][1], worker['length']), end='')
        except KeyboardInterrupt:
            print("\nKeyboardInterrupt has been caught.")
            break


if __name__ == "__main__":
    main()
