
if __package__:
    from ... import lt
else:
    import sys
    sys.path.append("../..")
    import lt


def main():
    client = lt.Client()

    # Find first active input video source
    sourceURL = ""
    sources = {
        "lt100:/0/cvbs-in/0",
        "lt100:/0/svideo-in/0",
        "lt100:/0/dvi-in/0", "lt100:/0/dvi-in/1",
        "lt100:/0/sdi-in/0", "lt100:/0/sdi-in/1",
    }
    for source in sources:
        input, err = client.Get(source)
        if err != None:
            exit(err)
        if input['video']['signal'] == 'locked':
            sourceURL = source
            break

    # If no active input video source found, use a default one
    if sourceURL == "":
        print("no active input video source found")
        sourceURL = "lt100:/0/sdi-in/0"

    # Create worker
    resp, err = client.Post(sourceURL+"/data", {'media': "image/yuv422"})
    if not lt.ErrorIs(err, lt.ErrRedirect):
        exit(err)
    workerURL = lt.RedirectLocation(err)

    # Fetch worker response
    worker, err = client.Get(workerURL)
    if err != None:
        exit(err)

    # Check packet
    if len(worker['packets']) == 0:
        exit("packet not found")
    packet = worker['packets'][0]

    # Packet metadata
    meta = packet['meta']

    # Print infos
    print("%s %dx%d %d bytes" %
          (sourceURL, meta['size'][0], meta['size'][1], len(packet['data'])))

    # Create histogram
    n = meta['size'][0] * meta['size'][1]
    h = [0] * 8
    for i in range(0, n):
        h[int(packet['data'][i] / 32)] += 1

    # Print histogram
    print("")
    print("  0.. 31: %.1f%%" % (100 * float(h[0]) / float(n)))
    print(" 32.. 63: %.1f%%" % (100 * float(h[1]) / float(n)))
    print(" 64.. 95: %.1f%%" % (100 * float(h[2]) / float(n)))
    print(" 96..127: %.1f%%" % (100 * float(h[3]) / float(n)))
    print("128..159: %.1f%%" % (100 * float(h[4]) / float(n)))
    print("160..191: %.1f%%" % (100 * float(h[5]) / float(n)))
    print("192..223: %.1f%%" % (100 * float(h[6]) / float(n)))
    print("224..256: %.1f%%" % (100 * float(h[7]) / float(n)))


if __name__ == "__main__":
    main()
