package lt

// GET /
type Agent struct {
	Version  string `json:"version"`
	Revision string `json:"revision"`
	Time     string `json:"time"`
}

// GET /:board
type Board struct {
	Model  string `json:"model"`
	SN     uint32 `json:"sn"`
	CPU    uint32 `json:"cpu"`
	FPGA   uint32 `json:"fpga"`
	Bridge uint32 `json:"bridge"`
}

// GET /:board/:input/:id
type Input struct {
	Audio struct {
		Description string `json:"description"`
		Format      string `json:"format"`
		Signal      string `json:"signal"`
		Channels    int    `json:"channels"`
		Samplerate  int    `json:"samplerate"`
		Depth       int    `json:"depth"`
	} `json:"audio"`
	Video struct {
		Description string  `json:"description"`
		Format      string  `json:"format"`
		Signal      string  `json:"signal"`
		Size        [2]int  `json:"size"`
		Framerate   float64 `json:"framerate"`
		Interlaced  bool    `json:"interlaced"`
	} `json:"video"`
}

// GET,POST /:board/:input/:id/edid
type Edid struct {
	Data []byte `json:"data"`
}

// GET,POST /:board/:output/:id
type Output struct {
	Source  string `json:"source"`
	Overlay string `json:"overlay"`
	Format  string `json:"format"`
	Link    string `json:"link"`

	Audio struct {
		Description string `json:"description"`
		Format      string `json:"format"`
		Signal      string `json:"signal"`
		Channels    int    `json:"channels"`
		Samplerate  int    `json:"samplerate"`
		Depth       int    `json:"depth"`
	} `json:"audio"`
	Video struct {
		Description string  `json:"description"`
		Format      string  `json:"format"`
		Signal      string  `json:"signal"`
		Size        [2]int  `json:"size"`
		Framerate   float64 `json:"framerate"`
		Interlaced  bool    `json:"interlaced"`
	} `json:"video"`
}

//
// Create DataWorker (POST)
//

type AudioDataWorker struct {
	Media string `json:"media"` // "audio/..."
	//Source string `json:"source"`

	// Format
	Channels   int `json:"channels"`
	Samplerate int `json:"samplerate"`
	Depth      int `json:"depth"`

	// Extra parameters
	//Extra any `json:"extra"`
}

type ImageDataWorker struct {
	Media string `json:"media"` // "image/..."
	//Source string `json:"source"`

	// Format
	Size [2]int `json:"size"`
	//MaxSize [2]int `json:"maxSize"`

	// Extra parameters
	//Extra any `json:"extra"`
}

type VideoDataWorker struct {
	Media string `json:"media"` // "video/..."
	//Source string `json:"source"`

	// Format
	Size      [2]int  `json:"size"`
	Framerate float64 `json:"framerate"`
	//MaxSize      [2]int  `json:"maxSize"`
	//MaxFramerate float64 `json:"maxFramerate"`

	// Extra parameters
	//Extra any `json:"extra"`
}

//
// Create FileWorker (POST)
//

type AudioFileWorker struct {
	Media string `json:"media"` // "audio/..."
	//Source string `json:"source"`

	// File
	Location      string `json:"location"`
	Duration      int64  `json:"duration"`
	SplitLength   int    `json:"splitLength"`
	SplitDuration int64  `json:"splitDuration"`

	// Format
	Channels   int `json:"channels"`
	Samplerate int `json:"samplerate"`

	// Extra parameters
	//Extra any `json:"extra"`
}

type ImageFileWorker struct {
	Media string `json:"media"` // "image/..."
	//Source string `json:"source"`

	// File
	Location string `json:"location"`

	// Format
	Size [2]int `json:"size"`
	//MaxSize [2]int `json:"maxSize"`

	// Extra parameters
	//Extra any `json:"extra"`
}

type VideoFileWorker struct {
	Media string `json:"media"` // "video/..."
	//Source string `json:"source"`

	// File
	Location      string `json:"location"`
	Duration      int64  `json:"duration"`
	SplitLength   int    `json:"splitLength"`
	SplitDuration int64  `json:"splitDuration"`

	// Format
	Size      [2]int  `json:"size"`
	Framerate float64 `json:"framerate"`
	//MaxSize      [2]int  `json:"maxSize"`
	//MaxFramerate float64 `json:"maxFramerate"`

	// Extra parameters
	//Extra any `json:"extra"`
}

// Packet metadata
type AudioMetadata struct {
	Channels   int `json:"channels"`
	Samplerate int `json:"samplerate"`
	Depth      int `json:"depth"`
	Samples    int `json:"samples"`
}

type ImageMetadata struct {
	Size [2]int `json:"size"`
}

type VideoMetadata struct {
	Size       [2]int  `json:"size"`
	Framerate  float64 `json:"framerate"`
	Interlaced bool    `json:"interlaced"`
	Keyframe   bool    `json:"keyframe"`
}

//
// Canvas
//

// POST /canvas/:id/init
type CanvasInit struct {
	Op string `json:"op"`

	Source string `json:"source"`

	Color     [4]int  `json:"color"`
	Size      [2]int  `json:"size"`
	Framerate float64 `json:"framerate"`
}

// POST /canvas/:id/text
type CanvasText struct {
	Op string `json:"op"`

	Text  string `json:"text"`
	Align string `json:"align"`

	// Shape
	Font     string `json:"font"`
	FontSize int    `json:"fontSize"`
	Italic   bool   `json:"italic"`
	Bold     bool   `json:"bold"`
	Color    [4]int `json:"color"`

	// Container
	Angle    float64    `json:"angle"`
	Position [2]int     `json:"position"`
	Size     [2]int     `json:"size"`
	Anchor   [2]float64 `json:"anchor"`
}

// POST /canvas/:id/line
type CanvasLine struct {
	Op string `json:"op"`

	// Shape
	Width   int    `json:"width"`
	Color   [4]int `json:"color"`
	Pattern []int  `json:"pattern"`

	// Container
	Angle    float64    `json:"angle"`
	Position [2]int     `json:"position"`
	Size     [2]int     `json:"size"`
	Anchor   [2]float64 `json:"anchor"`
}

// POST /canvas/:id/ellipse
type CanvasEllipse struct {
	Op string `json:"op"`

	// Shape
	Width   int    `json:"width"`
	Color   [4]int `json:"color"`
	Fill    [4]int `json:"fill"`
	Pattern []int  `json:"pattern"`

	// Container
	Angle    float64    `json:"angle"`
	Position [2]int     `json:"position"`
	Size     [2]int     `json:"size"`
	Anchor   [2]float64 `json:"anchor"`
}

// POST /canvas/:id/rectangle
type CanvasRectangle struct {
	Op string `json:"op"`

	// Shape
	Width   int    `json:"width"`
	Color   [4]int `json:"color"`
	Fill    [4]int `json:"fill"`
	Pattern []int  `json:"pattern"`
	Rounded int    `json:"rounded"`

	// Container
	Angle    float64    `json:"angle"`
	Position [2]int     `json:"position"`
	Size     [2]int     `json:"size"`
	Anchor   [2]float64 `json:"anchor"`
}

// POST /canvas/:id/image
type CanvasImage struct {
	Op string `json:"op"`

	// Source
	Source string `json:"source"`

	// Data
	Format string `json:"format"`
	Width  int    `json:"width"`
	Height int    `json:"height"`
	Data   []byte `json:"data"`

	// Container
	Angle    float64    `json:"angle"`
	Position [2]int     `json:"position"`
	Size     [2]int     `json:"size"`
	Anchor   [2]float64 `json:"anchor"`
}

// POST /canvas/:id/video
type CanvasVideo struct {
	Op string `json:"op"`

	// Source
	Source string `json:"source"`

	// Container
	Position [2]int     `json:"position"`
	Size     [2]int     `json:"size"`
	Anchor   [2]float64 `json:"anchor"`
}
