namespace lt
{
    // GET /
    public class Agent
    {
        public string version { get; set; } = "";
        public string revision { get; set; } = "";
        public string time { get; set; } = "";
    }

    // GET /:board
    public class Board
    {
        public string model { get; set; } = "";
        public uint sn { get; set; } = 0;
        public uint cpu { get; set; } = 0;
        public uint fpga { get; set; } = 0;
        public uint bridge { get; set; } = 0;
    }

    public class AudioSignal
    {
        public string description { get; set; } = "";
        public string format { get; set; } = "";
        public string signal { get; set; } = "";
        public int channels { get; set; } = 0;
        public int samplerate { get; set; } = 0;
        public int depth { get; set; } = 0;
    }

    public class VideoSignal
    {
        public string description { get; set; } = "";
        public string format { get; set; } = "";
        public string signal { get; set; } = "";
        public int[] size { get; set; } = new int[2];
        public float samplerate { get; set; } = 0;
        public bool interlaced { get; set; } = false;
    }

    // GET /:board/:input/:id
    public class Input
    {
        public AudioSignal audio { get; set; } = new AudioSignal();
        public VideoSignal video { get; set; } = new VideoSignal();
    }

    // GET,POST /:board/hdmi-in/:id/edid
    public class Edid
    {
        public byte[] data { get; set; } = new byte[256];
    }

    // GET /:board/:output/:id
    public class Output
    {
        public string source { get; set; } = "auto";
        public string overlay { get; set; } = "none";
        public string format { get; set; } = "auto";
        public string link { get; set; } = "auto";

        public AudioSignal audio { get; set; } = new AudioSignal();
        public VideoSignal video { get; set; } = new VideoSignal();
    }

    //
    // Create DataWorker (POST)
    //

    public class AudioDataWorker
    {
        public string media { get; set; }

        // Format
        public int channels { get; set; } = 0;
        public int samplerate { get; set; } = 0;
        public int depth { get; set; } = 0;
    }

    public class ImageDataWorker
    {
        public string media { get; set; }

        // Format
        public int[] size { get; set; } = new int[2];
    }

    public class VideoDataWorker
    {
        public string media { get; set; }

        // Format
        public int[] size { get; set; } = new int[2];
        public float framerate { get; set; } = 0;
    }

    //
    // Create FileWorker (POST)
    //

    public class AudioFileWorker
    {
        public string media { get; set; }

        // File
        public string location { get; set; }
        public int duration { get; set; } = 0;
        public int splitLength { get; set; } = 0;
        public int splitDuration { get; set; } = 0;

        // Format
        public int channels { get; set; } = 0;
        public int samplerate { get; set; } = 0;
        public int depth { get; set; } = 0;
    }

    public class ImageFileWorker
    {
        public string media { get; set; }

        // File
        public string location { get; set; }

        // Format
        public int[] size { get; set; } = new int[2];
    }

    public class VideoFileWorker
    {
        public string media { get; set; }

        // File
        public string location { get; set; }
        public int duration { get; set; } = 0;
        public int splitLength { get; set; } = 0;
        public int splitDuration { get; set; } = 0;


        // Format
        public int[] size { get; set; } = new int[2];
        public float framerate { get; set; } = 0;
    }

    //
    // Packets metadata
    //

    public class AudioMetadata
    {
        public int channels { get; set; } = 0;
        public int samplerate { get; set; } = 0;
        public int depth { get; set; } = 0;
        public int samples { get; set; } = 0;
    }

    public class ImageMetadata
    {
        public int[] size { get; set; } = new int[2];
    }

    public class VideoMetadata
    {
        public int[] size { get; set; } = new int[2];
        public float framerate { get; set; } = 0;
        public bool interlaced { get; set; } = false;
        public bool keyframe { get; set; } = false;
    }

    //
    // Canvas
    //

    // POST /canvas/:id/init
    public class CanvasInit
    {
        public string op { get; set; } = "init";

        public string source { get; set; } = "";

        public int[] color { get; set; } = new int[4];
        public int[] size { get; set; } = new int[2];
        public float framerate { get; set; } = 0;
    }

}