﻿using System;
using System.IO;

namespace StillCapture
{
    class Program
    {
        static void logFatal(string s)
        {
            Console.WriteLine(s);
            System.Environment.Exit(-1);
        }
        static void Main(string[] args)
        {
            lt.Error err;
            var client = new lt.Client();

            // Find first active input video source
            var sourceURL = "";
            string[] sources = new string[] {
                "lt100:/0/cvbs-in/0",
                "lt100:/0/svideo-in/0",
                "lt100:/0/dvi-in/0", "lt100:/0/dvi-in/1",
                "lt100:/0/sdi-in/0", "lt100:/0/sdi-in/1",
            };
            foreach (var source in sources)
            {
                lt.Input input;
                err = client.Get(source, out input);
                if (err != null)
                {
                    logFatal(err.ToString());
                }
                if (input.video.signal == "locked")
                {
                    sourceURL = source;
                    break;
                }
            }

            // If no active input video source found, use a default one
            if (sourceURL == "")
            {
                Console.WriteLine("no active input video source found");
                sourceURL = "lt100:/0/sdi-in/0";
            }

            // Create worker
            err = client.Post(sourceURL + "/file", new lt.ImageFileWorker { media = "image/jpeg", location = Directory.GetCurrentDirectory() }, out _);
            if (!lt.Errors.Is(err, lt.Errors.ErrRedirect))
            {
                logFatal("worker creation failed: " + err.ToString());
            }
            var workerURL = lt.Errors.RedirectLocation(err);

            // Fetch worker response
            lt.Worker worker;
            err = client.Get(workerURL, out worker);
            if (err != null)
            {
                logFatal(err.ToString());
            }

            // Check packet
            if (worker.packets.Length == 0)
            {
                logFatal("worker packet: not found");
            }
            var packet = worker.packets[0];
            var meta = packet.meta.ToObject<lt.ImageMetadata>();

            // Print file information
            Console.WriteLine("{0} {1} {2}x{3} {4} bytes", sourceURL, worker.name, meta.size[0], meta.size[1], worker.length);
        }
    }
}
