#ifndef __LT_SCHEMA_H__
#define __LT_SCHEMA_H__

// Third party JSON library (MIT License): https://github.com/nlohmann/json
#include "json.hpp"

namespace lt {

// Type aliases
using string = std::string;
using bytes = std::vector<char>;
using json = nlohmann::json;

// GET /
struct Agent {
    string version = "";
    string revision = "";
    string time = "";
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(Agent, version, revision, time)

// GET /:board
struct Board {
    string model = "";
    unsigned int sn = 0;
    unsigned int cpu = 0;
    unsigned int fpga = 0;
    unsigned int bridge = 0;
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(Board, model, sn, cpu, fpga, bridge)

//
struct AudioSignal {
    string description = "";
    string format = "";
    string signal = "";
    int channels = 0;
    int samplerate = 0;
    int depth = 0;
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(AudioSignal, description, format, signal, channels, samplerate, depth)

struct VideoSignal {
    string description = "";
    string format = "";
    string signal = "";
    int size[2] = {};
    double framerate = 0;
    bool interlaced = false;
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(VideoSignal, description, format, signal, size, framerate, interlaced)

// GET /:board/:input/:id
struct Input {
    AudioSignal audio = {};
    VideoSignal video = {};
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(Input, audio, video)

// GET,POST /:board/:input/:id/edid
struct Edid {
    bytes Data = {};
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(Edid, Data)

// GET,POST /:board/:output/:id
struct Output {
    string source = "auto";
    string overlay = "none";
    string format = "auto";
    string link = "auto";

    AudioSignal audio = {};
    VideoSignal video = {};
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(Output, source, overlay, format, link, audio, video)

//
// Create DataWorker (POST)
//

struct AudioDataWorker {
    string media;
    // string Source;

    // Format
    int channels = 0;
    int samplerate = 0;
    int depth = 0;

    // Extra parameters
    // json Extra;
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(AudioDataWorker, media, channels, samplerate, depth)

struct ImageDataWorker {
    string media;
    // string Source;

    // Format
    int size[2] = {};
    // int maxSize[2] = {};

    // Extra parameters
    // json Extra;
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(ImageDataWorker, media, size)

struct VideoDataWorker {
    string media;
    // string Source;

    // Format
    int size[2] = {};
    double framerate = 0.0;

    // int maxSize[2] = {};
    // double maxFramerate = 0.0;

    // Extra parameters
    // json extra;
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(VideoDataWorker, media, size, framerate)

//
// Create FileWorker (POST)
//

struct AudioFileWorker {
    string media;
    // string Source;

    // File
    string location;
    int duration = 0;
    int splitLength = 0;
    int splitDuration = 0;

    // Format
    int channels = 0;
    int samplerate = 0;
    int depth = 0;

    // Extra parameters
    // json Extra;
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(AudioFileWorker, media, location, duration, splitLength, splitDuration, channels, samplerate, depth)

struct ImageFileWorker {
    string media;
    // string Source;

    // File
    string location;

    // Format
    int size[2] = {};
    // int maxSize[2] = {};

    // Extra parameters
    // json Extra;
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(ImageFileWorker, media, location, size)

struct VideoFileWorker {
    string media;
    // string Source;

    // File
    string location;
    int duration = 0;
    int splitLength = 0;
    int splitDuration = 0;

    // Format
    int size[2] = {};
    double framerate = 0.0;

    // int maxSize[2] = {};
    // double maxFramerate = 0.0;

    // Extra parameters
    // json Extra;
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(VideoFileWorker, media, location, duration, splitLength, splitDuration, size, framerate)

// Packet metadata
struct AudioMetadata {
    int channels = 0;
    int samplerate = 0;
    int depth = 0;
    int samples = 0;
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(AudioMetadata, channels, samplerate, depth, samples)

struct ImageMetadata {
    int size[2] = {};
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(ImageMetadata, size)

struct VideoMetadata {
    int size[2] = {};
    double framerate = 0.0;
    bool interlaced = 0;
    bool keyframe = false;
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(VideoMetadata, size, framerate, interlaced, keyframe)

//
// Canvas
//

// POST /canvas/:id/init
struct CanvasInit {
    string op = "init";

    string source = "";

    int color[4] = {};
    int size[2] = {};
    double framerate = 0.0;
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(CanvasInit, op, source, color, size, framerate)

// POST /canvas/:id/text
struct CanvasText {
    string op = "text";

    string text = "";
    string align = "";

    // Shape
    string font = "";
    int fontSize = 0;
    bool italic = false;
    bool bold = false;
    int color[4] = {};

    // Container
    double angle = 0.0;
    int position[2] = {};
    int size[2] = {};
    double anchor[2] = {};
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(CanvasText, op, text, align, font, fontSize, italic, bold, color, angle, position, size, anchor)

// POST /canvas/:id/line
struct CanvasLine {
    string op = "line";

    // Shape
    int width = 0;
    int color[4] = {};
    int fill[4] = {};

    // Container
    double angle = 0.0;
    int position[2] = {};
    int size[2] = {};
    double anchor[2] = {};
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(CanvasLine, op, width, color, fill, angle, position, size, anchor)

// POST /canvas/:id/ellipse
struct CanvasEllipse {
    string op = "ellipse";

    // Shape
    int width = 0;
    int color[4] = {};
    int fill[4] = {};

    // Container
    double angle = 0.0;
    int position[2] = {};
    int size[2] = {};
    double anchor[2] = {};
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(CanvasEllipse, op, width, color, fill, angle, position, size, anchor)

// POST /canvas/:id/rectangle
struct CanvasRectangle {
    string op = "rectangle";

    // Shape
    int width = 0;
    int color[4] = {};
    int fill[4] = {};
    int rounded = 0;

    // Container
    double angle = 0.0;
    int position[2] = {};
    int size[2] = {};
    double anchor[2] = {};
};

NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(CanvasRectangle, op, width, color, fill, rounded, angle, position, size, anchor)

// POST /canvas/:id/image

// POST /canvas/:id/video

} // namespace lt

#endif // __LT_SCHEMA_H__