#ifndef YUYV_H
#define YUYV_H

#include "glad/gl.h"
#include <string>

using string = std::string;
using error = std::string;

error loadShader(int t, const char* source, int* shader);
error loadProgram(const char* vertexSource, const char* fragmentSource, int* program);

class YUYV {
public:
    error err;
    YUYV();
    void Draw(int width, int height, char* data);

private:
    int32_t shaderProgram;
    int32_t yTexture, uvTexture;
    uint32_t yTextureName, uvTextureName;
    uint32_t vbo, ebo;
    uint32_t posAttrib, texAttrib;
};

#endif