#!/bin/bash

# List of Python packages
PY_PACKAGES=(glfw pyaudio PyOpenGL numpy)

# Usage
if [[ "$1" != "install" && "$1" != "remove" ]]; then
  echo "$0 [install|remove]"
  exit 1
fi

# Install function
install_deps() {
  echo "PortAudio development library..."
  if dpkg -s portaudio19-dev &> /dev/null; then
    echo "PortAudio development library already installed."
  else
    echo "Installing PortAudio development library..."
    sudo apt-get update
    sudo apt-get install -y portaudio19-dev
  fi

  for pkg in "${PY_PACKAGES[@]}"; do
    echo "Checking if ${pkg} is installed..."
    if python3 -c "import ${pkg}" &> /dev/null; then
      echo "${pkg} is already installed."
    else
      echo "Installing ${pkg}..."
      pip install --user ${pkg}
    fi
  done

  echo "All dependencies installed or already present."
}

# Remove function
remove_deps() {
  echo "Removing Python packages..."
  for pkg in "${PY_PACKAGES[@]}"; do
    if python3 -c "import ${pkg}" &> /dev/null; then
      echo "Uninstalling ${pkg}..."
      pip uninstall -y ${pkg}
    else
      echo "${pkg} is not installed, skipping."
    fi
  done

  echo "Removing PortAudio development library..."
  if dpkg -s portaudio19-dev &> /dev/null; then
    sudo apt-get remove -y portaudio19-dev
    sudo apt-get autoremove -y
    echo "PortAudio development library removed."
  else
    echo "PortAudio development library not installed, skipping."
  fi

  echo "All requested dependencies removed or not present."
}

# Main
if [[ "$1" == "install" ]]; then
  install_deps
elif [[ "$1" == "remove" ]]; then
  remove_deps
fi
