package surface

import (
	"log"
)

// Register OpenGL surfaces
var yuyv *YUYV
var nv12 *NV12

func Init() error {
	var err error

	yuyv, err = NewYUYV()
	if err != nil {
		return err
	}
	nv12, err = NewNV12()
	if err != nil {
		return err
	}
	return nil
}

func Draw(format string, width, height int, data []byte) {
	switch format {
	case "video/yuyv":
		yuyv.Draw(width, height, data)
	case "video/nv12":
		nv12.Draw(width, height, data)
	default:
		log.Fatal("unknown surface format: ", format)
	}
}
