#ifndef NV12_H
#define NV12_H

#include "glad/gl.h"
#include <string>

using string = std::string;
using error = std::string;

error loadShader(int t, const char* source, int* shader);
error loadProgram(const char* vertexSource, const char* fragmentSource, int* program);

class NV12 {
public:
    error err;
    NV12();
    ~NV12();
    void Draw(int width, int height, char* data);

private:
    int32_t shaderProgram = 0;
    int32_t yTexture = 0, uvTexture = 0;
    uint32_t yTextureName = 0, uvTextureName = 0;
    uint32_t vbo = 0, ebo = 0;
    uint32_t posAttrib = 0, texAttrib = 0;
    
    // Track current texture sizes to avoid unnecessary reallocations
    int currentYWidth = 0, currentYHeight = 0;
    int currentUVWidth = 0, currentUVHeight = 0;
};

#endif
